﻿#nullable enable
namespace Hims.Api.Models.MailTemplates
{
    using System;
    using System.Collections.Generic;

    using Hims.Shared.EntityModels;

    /// <summary>
    /// The tickets.
    /// </summary>
    public class Tickets
    {
        /// <summary>
        /// Gets or sets the ticket number.
        /// </summary>
        public string? TicketNumber { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        public string? Priority { get; set; }

        /// <summary>
        /// Gets or sets the issue with.
        /// </summary>
        public string? IssueWith { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string? Description { get; set; }

        /// <summary>
        /// Gets or sets the raised by name.
        /// </summary>
        public string? RaisedByName { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Mobile { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string? Status { get; set; }

        /// <summary>
        /// Gets or sets the assignee name.
        /// </summary>
        public string? AssigneeName { get; set; }

        /// <summary>
        /// Gets or sets the ticket owner.
        /// </summary>
        public string? TicketOwner { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the raised by role.
        /// </summary>
        public string? RaisedByRole { get; set; }

        /// <summary>
        /// Gets or sets the ios app link.
        /// </summary>
        public string IOSAppLink { get; set; }

        /// <summary>
        /// Gets or sets the android app link.
        /// </summary>
        public string AndroidAppLink { get; set; }

        /// <summary>
        /// Gets or sets the mail templates images link.
        /// </summary>
        public string MailTemplatesImagesLink { get; set; }

        /// <summary>
        /// Gets or sets the support users.
        /// </summary>
        public IEnumerable<AccountModel> SupportUsers { get; set; }

        /// <summary>
        /// Gets or sets the email type.
        /// </summary>
        public string EmailType { get; set; }
    }
}
